/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.CallingFormat;
import com.amazon.s3.S3Object;
import com.amazon.s3.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class QueryStringAuthGenerator {
    private String awsAccessKeyId;
    private String awsSecretAccessKey;
    private boolean isSecure;
    private String server;
    private int port;
    private CallingFormat callingFormat;
    private Long expiresIn = null;
    private Long expires = null;
    private static final Long DEFAULT_EXPIRES_IN = new Long(60000L);

    public QueryStringAuthGenerator(String awsAccessKeyId, String awsSecretAccessKey) {
        this(awsAccessKeyId, awsSecretAccessKey, true);
    }

    public QueryStringAuthGenerator(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, "s3.amazonaws.com");
    }

    public QueryStringAuthGenerator(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, isSecure ? 443 : 80);
    }

    public QueryStringAuthGenerator(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int port) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, port, CallingFormat.getSubdomainCallingFormat());
    }

    public QueryStringAuthGenerator(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, CallingFormat callingFormat) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, isSecure ? 443 : 80, callingFormat);
    }

    public QueryStringAuthGenerator(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int port, CallingFormat callingFormat) {
        this.awsAccessKeyId = awsAccessKeyId;
        this.awsSecretAccessKey = awsSecretAccessKey;
        this.isSecure = isSecure;
        this.server = server;
        this.port = port;
        this.callingFormat = callingFormat;
        this.expiresIn = DEFAULT_EXPIRES_IN;
        this.expires = null;
    }

    public void setCallingFormat(CallingFormat format) {
        this.callingFormat = format;
    }

    public void setExpires(long millisSinceEpoch) {
        this.expires = new Long(millisSinceEpoch);
        this.expiresIn = null;
    }

    public void setExpiresIn(long millis) {
        this.expiresIn = new Long(millis);
        this.expires = null;
    }

    public String createBucket(String bucket, Map headers) {
        if (!Utils.validateBucketName(bucket, this.callingFormat, false)) {
            throw new IllegalArgumentException("Invalid Bucket Name: " + bucket);
        }
        HashMap pathArgs = new HashMap();
        return this.generateURL("PUT", bucket, "", pathArgs, headers);
    }

    public String listBucket(String bucket, String prefix, String marker, Integer maxKeys, Map headers) {
        return this.listBucket(bucket, prefix, marker, maxKeys, null, headers);
    }

    public String listBucket(String bucket, String prefix, String marker, Integer maxKeys, String delimiter, Map headers) {
        Map pathArgs = Utils.paramsForListOptions(prefix, marker, maxKeys, delimiter);
        return this.generateURL("GET", bucket, "", pathArgs, headers);
    }

    public String deleteBucket(String bucket, Map headers) {
        HashMap pathArgs = new HashMap();
        return this.generateURL("DELETE", bucket, "", pathArgs, headers);
    }

    public String put(String bucket, String key, S3Object object, Map headers) {
        Map metadata = null;
        HashMap pathArgs = new HashMap();
        if (object != null) {
            metadata = object.metadata;
        }
        return this.generateURL("PUT", bucket, Utils.urlencode(key), pathArgs, this.mergeMeta(headers, metadata));
    }

    public String get(String bucket, String key, Map headers) {
        HashMap pathArgs = new HashMap();
        return this.generateURL("GET", bucket, Utils.urlencode(key), pathArgs, headers);
    }

    public String delete(String bucket, String key, Map headers) {
        HashMap pathArgs = new HashMap();
        return this.generateURL("DELETE", bucket, Utils.urlencode(key), pathArgs, headers);
    }

    public String getBucketLogging(String bucket, Map headers) {
        HashMap<String, Object> pathArgs = new HashMap<String, Object>();
        pathArgs.put("logging", null);
        return this.generateURL("GET", bucket, "", pathArgs, headers);
    }

    public String putBucketLogging(String bucket, String loggingXMLDoc, Map headers) {
        HashMap<String, Object> pathArgs = new HashMap<String, Object>();
        pathArgs.put("logging", null);
        return this.generateURL("PUT", bucket, "", pathArgs, headers);
    }

    public String getBucketACL(String bucket, Map headers) {
        return this.getACL(bucket, "", headers);
    }

    public String getACL(String bucket, String key, Map headers) {
        HashMap<String, Object> pathArgs = new HashMap<String, Object>();
        pathArgs.put("acl", null);
        return this.generateURL("GET", bucket, Utils.urlencode(key), pathArgs, headers);
    }

    public String putBucketACL(String bucket, String aclXMLDoc, Map headers) {
        return this.putACL(bucket, "", aclXMLDoc, headers);
    }

    public String putACL(String bucket, String key, String aclXMLDoc, Map headers) {
        HashMap<String, Object> pathArgs = new HashMap<String, Object>();
        pathArgs.put("acl", null);
        return this.generateURL("PUT", bucket, Utils.urlencode(key), pathArgs, headers);
    }

    public String listAllMyBuckets(Map headers) {
        HashMap pathArgs = new HashMap();
        return this.generateURL("GET", "", "", pathArgs, headers);
    }

    public String makeBareURL(String bucket, String key) {
        StringBuffer buffer = new StringBuffer();
        if (this.isSecure) {
            buffer.append("https://");
        } else {
            buffer.append("http://");
        }
        buffer.append(this.server).append(":").append(this.port).append("/").append(bucket);
        buffer.append("/").append(Utils.urlencode(key));
        return buffer.toString();
    }

    private String generateURL(String method, String bucketName, String key, Map pathArgs, Map headers) {
        String returnString;
        long expires = 0L;
        if (this.expiresIn != null) {
            expires = System.currentTimeMillis() + this.expiresIn;
        } else if (this.expires != null) {
            expires = this.expires;
        } else {
            throw new RuntimeException("Illegal expires state");
        }
        String canonicalString = Utils.makeCanonicalString(method, bucketName, key, pathArgs, headers, "" + (expires /= 1000L));
        String encodedCanonical = Utils.encode(this.awsSecretAccessKey, canonicalString, true);
        pathArgs.put("Signature", encodedCanonical);
        pathArgs.put("Expires", Long.toString(expires));
        pathArgs.put("AWSAccessKeyId", this.awsAccessKeyId);
        CallingFormat callingFormat = Utils.getCallingFormatForBucket(this.callingFormat, bucketName);
        if (this.isSecure && callingFormat != CallingFormat.getPathCallingFormat() && bucketName.indexOf(".") != -1) {
            System.err.println("You are making an SSL connection, however, the bucket contains periods and the wildcard certificate will not match by default.  Please consider using HTTP.");
        }
        try {
            URL url = callingFormat.getURL(this.isSecure, this.server, this.port, bucketName, key, pathArgs);
            returnString = url.toString();
        }
        catch (MalformedURLException e) {
            returnString = "Exception generating url " + e;
        }
        return returnString;
    }

    private Map mergeMeta(Map headers, Map metadata) {
        TreeMap merged = new TreeMap();
        if (headers != null) {
            for (String key : headers.keySet()) {
                merged.put(key, headers.get(key));
            }
        }
        if (metadata != null) {
            for (String key : metadata.keySet()) {
                String metadataKey = "x-amz-meta-" + key;
                if (merged.containsKey(metadataKey)) {
                    ((List)merged.get(metadataKey)).addAll((List)metadata.get(key));
                    continue;
                }
                merged.put(metadataKey, metadata.get(key));
            }
        }
        return merged;
    }
}

